<?php

use Illuminate\Support\Collection;
use Inside\Host\Bridge\BridgeContent;

function get_entity_reference(mixed $user, BridgeContent $bridge, string $attribute, string $contentType): ?string
{
    $title = $user->{$attribute};

    if (!$title) {
        return null;
    }

    $entity = call_user_func(type_to_class($contentType).'::query')
        ->where('title', $title)->first();

    if ($entity) {
        $uuid = $entity->uuid;
    } else {
        $uuid = $bridge->contentInsert($contentType, [
            'type' => 'node',
            'bundle' => $contentType,
            'title' => $title,
        ]);
    }

    return $uuid;
}

return [
    'postfilter' => function (Collection $users) {
        return $users->filter(fn (mixed $user) => $user->accountEnabled && preg_match('/^(C|c)[0,1]/', $user->userPrincipalName));
    },
    'sync_attributes' => [
        'mail' => fn (mixed $user) => $user->mail ?? $user->userPrincipalName,
        'name' => 'userPrincipalName',
        'lastname' => 'surname',
        'firstname' => 'givenName',
        'function' => 'jobTitle',
        'phone' => fn (mixed $user) => $user->businessPhones[0] ?? null,
        'services' => function ($user, BridgeContent $bridge) {
            $serviceUuid = get_entity_reference($user, $bridge, 'department', 'services');
            return $serviceUuid ? [$serviceUuid] : null;
        },
        'status' => fn () => 1,
        'is_maintenance' => fn () => false,
    ],
];
