<?php

namespace Inside\CETP\Providers;

use Inside\CETP\Listeners\UserDefaultToolsListener;
use Inside\Content\Events\ContentFullyInsertedEvent;
use Inside\Support\EventServiceProvider as BaseServiceProvider;

/**
 * CETP Service provider.
 *
 * @category Class
 * @package  Inside\\CETP\Providers\ServiceProvider
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class ServiceProvider extends BaseServiceProvider
{
    protected array $listen = [
        ContentFullyInsertedEvent::class => [
            UserDefaultToolsListener::class,
        ],
    ];

    public function register()
    {
        $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/scheduler.php', 'scheduler');
        $this->mergeConfigTo(__DIR__.'/../../config/azuread.php', 'azuread');
        $this->mergeConfigTo(__DIR__.'/../../config/notify.php', 'notify');
    }
}
