<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\Spaces;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

class UpdateSpaces extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        $this->bridge->contentTypeCreateOrUpdateField('spaces', 'is_listed', [
            'name' => 'is_listed',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'title' => [
                'fr' => 'Apparaît dans la liste des espaces',
            ],
            'widget' => [
                'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [
                    'display_label' => true,
                ],
            ],
            'type' => BridgeContentType::BOOLEAN_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
            'default' => true,
        ]);

        $bridgeContent = new BridgeContent();
        Spaces::each(function (Spaces $space) use ($bridgeContent) {
            $bridgeContent->contentUpdate('spaces', ['uuid' => $space->uuid, 'is_listed' => true]);
        });

        $this->finishUp();
    }
}
