<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\Custom;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Migrations\CreateContentTypes;

class AddCustoms extends Migration
{
    public function up(): void
    {
        $customs = [
            [
                'title' => 'Quoi de neuf ?',
                'custom_slug' => 'news',
                'redirection_page' => 'NewsListingPage',
            ],
            [
                'title' => 'À vos agendas !',
                'custom_slug' => 'calendar',
                'redirection_page' => 'EventsCalendarPage',
            ],
            [
                'title' => 'Les équipes de la CNETP',
                'custom_slug' => 'directory',
                'redirection_page' => 'DirectoryPage',
            ],
            [
                'title' => 'Organigramme',
                'introduction' => 'Retrouvez l’organisation du lorem ipsum dolor sit amet',
                'custom_slug' => 'organizational-charts',
                'redirection_page' => 'OrganizationsListingPage',
            ],
            [
                'title' => 'Bibliothèque de documents',
                'introduction' => 'Retrouvez tous les documents, photos, fiches pratiques...',
                'custom_slug' => 'ged',
                'redirection_page' => 'GedPage',
            ],
            [
                'title' => 'Vos outils et liens utiles CNETP',
                'custom_slug' => 'tools',
                'redirection_page' => 'ToolsPage',
            ],
            [
                'title' => 'Les Espaces Services',
                'redirection_page' => 'SpacesListingPage',
                'custom_slug' => 'spaces'
            ],
        ];

        $bridge = new BridgeContent();

        foreach ($customs as $custom) {
            $uuid = Custom::where('redirection_page', $custom['redirection_page'])->first()?->uuid;
            if ($uuid) {
                $custom['uuid'] = $uuid;
                $bridge->contentUpdate('custom', $custom);
            } else {
                $bridge->contentInsert('custom', $custom);
            }
        }
    }
}
