import SpacesPage from '../pages/spaces/SpacesPage.vue'
import TabsPage from '../pages/tabs/TabsPage.vue'

import { fetchSpacesPage } from '../components/spaces/spaces'
import { fetchTabsPage } from '../components/tabs/tabs'

import { withFetch } from 'inside-collection/hocs'

import { CONTENTS } from '@inside-ged/constants/default-contents'

const folderContents = CONTENTS()

export default [
  {
    name: 'HomePage',
    component: () => import('../pages/HomePage'),
    meta: { disabled: false }
  },
  {
    name: 'EventsCalendarPage',
    meta: { disabled: false }
  },
  {
    name: 'EventPage',
    meta: { disabled: false }
  },
  {
    name: 'EventSubscriptionPage',
    meta: { disabled: false }
  },
  {
    name: 'SpacesPage',
    path: '/espaces/:slug',
    component: withFetch(SpacesPage, { size: 'xxl' })(fetchSpacesPage)
  },
  {
    name: 'TabsPage',
    path: '/page-onglet/:slug',
    component: withFetch(TabsPage, { size: 'xxl' })(fetchTabsPage)
  },
  {
    name: 'NewsListingPage',
    meta: { disabled: false },
    props: {
      component: 'minimal'
    }
  },
  {
    name: 'NewsPage',
    meta: { disabled: false }
  },
  {
    name: 'GedPage',
    meta: { disabled: false },
    props: {
      cardOverlayEnabled: false,
      folderTypes: {
        ...folderContents.folders,
        filters: {
          'status:eq': 1,
          sort: 'weight:asc'
        },
        fields: [...folderContents.folders.fields]
      }
    }
  },
  {
    name: 'DirectoryPage',
    component: () => import('../pages/directory/DirectoryPage'),
    meta: { disabled: false }
  },
  {
    name: 'SimplePage',
    meta: { disabled: false }
  },
  {
    name: 'ToolsPage',
    meta: { disabled: false },
    props: {
      requestFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      },
      toolsFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      }
    }
  },
  {
    name: 'MapPage',
    meta: { disabled: false }
  }
]
