import { http } from '@inside-library/helpers/Http'

export default {
  spaces: {
    add: ({ data }) => ({
      name: 'SpacesPage',
      params: { slug: data.slug[0] }
    })
  },
  tabsPages: {
    add: ({ data }) => ({
      name: 'TabsPage',
      params: { slug: data.slug[0] }
    })
  },
  tabs: {
    fields: [{ tabs_pages: ['slug'] }],
    add: ({ data }) => ({
      name: 'TabsPage',
      params: { slug: data.tabs_pages.slug[0] }
    }),
    delete: ({ data }) => ({
      name: 'TabsPage',
      params: { slug: data.tabs_pages.slug[0] }
    })
  },
  tabsContents: {
    fields: ['uuid', { tabs: [{ tabs_pages: ['slug'] }] }],
    add: ({ data }) => ({
      name: 'TabsPage',
      params: {
        slug: data.tabs.tabs_pages.slug[0]
      },
      query: { page: data.uuid }
    }),
    delete: ({ data }) => ({
      name: 'TabsPage',
      params: {
        slug: data.tabs.tabs_pages.slug[0]
      }
    }),
    globalSearch: async ({ data }) => {
      const { data: tabs } = await http.get('content/tabs', {
        fields: ['uuid', { tab: ['uuid', 'title'] }],
        filters: { 'uuid:eq': data.uuid }
      })

      const { data: space } = await http.get('content/spaces', {
        fields: ['uuid', { spaces: ['uuid', 'title', 'slug'] }],
        filters: { 'uuid:eq': tabs[0].space.uuid }
      })

      return {
        route: {
          name: 'SpacesPagesPage',
          params: {
            slug: space[0].space.slug[0]
          },
          query: { page: data.uuid }
        }
      }
    }
  }
}
