import { http } from '@inside-library/helpers/Http'

export const fetchTabsPage = async ({ $route }) => {
  try {
    const { data } = await http.get('content/tabs_pages', {
      fields: [
        'uuid',
        'title',
        'slug',
        'content_type',
        'introduction',
        'banner'
      ],
      filters: {
        'slug:eq': $route.params.slug
      }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}
