import { http } from '@inside-library/helpers/Http'

export const fetchSpacesPage = async ({ $route }) => {
  try {
    const { data } = await http.get('content/spaces', {
      fields: [
        'uuid',
        'admin',
        'title',
        'slug',
        'content_type',
        'introduction',
        'presentation',
        'news_label',
        'banner',
        {
          groups: {
            fields: [
              'langcode',
              'published_at',
              'status',
              'title',
              'updated_at',
              'uuid',
              'visibility',
              'slug'
            ]
          }
        },
        {
          users: {
            fields: [
              'firstname',
              'function',
              'image',
              'lastname',
              'phone',
              'status',
              'uuid'
            ]
          }
        },
        {
          link_photos: {
            fields: ['uuid', 'image', 'link', 'weight', 'title'],
            filters: {
              'archived:eq': 0,
              sort: 'weight:asc'
            }
          }
        },
        {
          blocks: {
            fields: [
              'uuid',
              'title',
              'background_color',
              'image',
              'link',
              'link_label',
              'visible_space',
              'admin',
              'content_type',
              'open_in_new_tab'
            ],
            filters: {
              reverse: true,
              'archived:eq': 0,
              'status:eq': 1,
              sort: 'weight:asc'
            }
          }
        },
        {
          events_category: {
            fields: ['uuid'],
            filters: {
              'archived:eq': 0,
              'status:eq': 1
            }
          }
        },
        {
          tools: {
            fields: [
              'title',
              'uuid',
              'has_section',
              'tools_link',
              'admin',
              'image',
              'class',
              'content_type',
              {
                tools_categories: [
                  'uuid',
                  { tools_categories_listings: ['uuid', 'slug'] }
                ]
              }
            ],
            filters: {
              'archived:eq': 0,
              'status:eq': 1,
              limit: 2
            }
          }
        },
        {
          news_categories: {
            fields: [
              'uuid',
              'title',
              {
                news: {
                  fields: [
                    'uuid',
                    'title',
                    'slug',
                    'chapo',
                    'published_at',
                    'image',
                    'content_type',
                    { news_categories: ['uuid', 'title', 'color'] },
                    { reactions: ['count', { users: ['uuid'] }] },
                    { comments: ['count'] }
                  ],
                  filters: {
                    reverse: true,
                    'status:eq': 1,
                    'archived:eq': 0,
                    sort: 'published_at:desc',
                    'published_at:lte': 'now()',
                    limit: 4
                  }
                }
              }
            ],
            filters: {
              'status:eq': 1,
              'published_at:lte': 'now()',
              'archived:eq': 0
            }
          }
        }
      ],
      filters: { 'slug:eq': $route.params.slug }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}
