<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;
use Inside\Authentication\Models\User;
use Inside\Import\Models\UserReference;

final class UpdateUserProviderReferences extends Migration
{
    public function up(): void
    {
        $userReferenceTable = app(UserReference::class)->getTable();
        $userTable = app(User::class)->getTable();

        DB::table($userReferenceTable)
            ->join($userTable, 'user_id', '=', 'uuid')
            ->where("$userReferenceTable.provider_type", 'azuread')
            ->where("$userReferenceTable.provider_name", 'default')
            ->update(['reference' => DB::raw("$userTable.email")]);
    }
}
