<?php

return [
    'postfilter' => function ($users) {
        return $users->reject(function ($user) {
            if (! isset($user->accountEnabled) || $user->accountEnabled === false) {
                return true;
            }
            if (! isset($user->companyName) || blank($user->companyName)) {
                return true;
            }
            if (! in_array($user->onPremisesExtensionAttributes?->extensionAttribute11 ?? '', [
                'LFDE-EXT',
                'LFDE-INT',
                'LBPAM-EXT',
                'LBPAM-INT',
                'LBPAM-NOPE'
            ])) {
                return true;
            }

            return false;
        })->map(function ($user) {
            if (! empty($user->businessPhones)) {
                $user->businessPhones = $user->businessPhones[0];
            }

            $user->mail = strtolower($user->mail);

            return $user;
        });
    },
    'discovering_attribute' => 'email',
    'sync_attributes' => [
        'email' => 'mail',
        'name' => 'mail',
        'lastname' => 'surname',
        'firstname' => 'givenName',
        'function' => 'jobTitle',
        'phone' => 'businessPhones',
        'mobile_phone' => 'mobilePhone',
        'services' => fn ($user) => reference('services')->from($user->department)->get(),
        'companies' => fn ($user) => reference('companies')->from($user->onPremisesExtensionAttributes->extensionAttribute11)->get(),
        'status' => fn () => true,
        'is_maintenance' => fn () => false,
    ],
    'custom_attributes' => [],
];
