<?php

namespace Inside\BPAM\Providers;

use Illuminate\Support\Facades\Event;
use Inside\BPAM\Listeners\FlashNotificationsListener;
use Inside\Content\Events\ContentFullyInsertedEvent;
use Inside\Content\Events\ContentFullyUpdatedEvent;
use Inside\Providers\ServiceProvider as BaseServiceProvider;
use Psr\Container\ContainerExceptionInterface;
use Psr\Container\NotFoundExceptionInterface;

/**
 * BPAM Service provider.
 *
 * @category Class
 * @package  Inside\\BPAM\Providers\ServiceProvider
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class ServiceProvider extends BaseServiceProvider
{
    /**
     * Boot
     */
    public function boot(): void
    {
        $this->loadMigrationsFrom(__DIR__ . '/../../database/migrations');
    }

    /**
     * Register
     */
    public function register(): void
    {
        try {
            $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/scheduler.php', 'scheduler');
            $this->mergeConfigTo(__DIR__.'/../../config/notify.php', 'notify');
            $this->mergeConfigTo(__DIR__.'/../../config/azuread.php', 'azuread');
            $this->mergeConfigTo(__DIR__.'/../../config/user_references.php', 'user_references');
            $this->mergeConfigTo(__DIR__.'/../../config/onesignal.php', 'onesignal');
        } catch (NotFoundExceptionInterface|ContainerExceptionInterface) {
        }
    }
}
