<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\Users;
use Inside\Notify\Models\NotificationSubscriber;
use Inside\Notify\Models\NotificationType;
use Inside\Notify\Models\NotificationTypeRole;
use Inside\Permission\Models\Role;

class CreateNotificationsDesktopTypes extends Migration
{
    public function up(): void
    {
        $notificationTypes[] = NotificationType::firstOrCreate(
            [
                'via' => 'push_desktop',
                'default' => true,
                'event' => 'Inside\Content\Events\ContentCreatedEvent',
                'model' => 'Inside\Content\Models\Contents\Comments',
                'action' => 'contentCommented',
                'type' => 'global',
                'condition' => 'parent_type:news,events|author:CURRENT_USER',
                'multiple' => true,
                'profile' => true,
                'data' => [
                    'title' => 'notifications.create.comment.content.title',
                    'description' => 'notifications.create.comment.content.description',
                    'icon' => 'comment',
                    'push' => [
                        'subject' => 'notifications.create.comment.content.title',
                        'content' => 'notifications.create.comment.<content_type>.text',
                    ],
                    'fields' => [
                        'title',
                        'content_type',
                    ],
                ]
            ]
        );

        $notificationTypes[] = NotificationType::firstOrCreate(
            [
                'via' => 'push_desktop',
                'default' => true,
                'event' => 'Inside\Content\Events\UserMentionedInCommentEvent',
                'model' => 'Inside\Content\Models\Contents\Comments',
                'action'    => 'userMentioned',
                'type' => 'global',
                'condition' => 'parent_type:news,events',
                'multiple' => true,
                'language' => false,
                'profile' => true,
            ],
            [
                'data' => [
                    'title' => 'notifications.mention.mail.subject',
                    'description' => 'notifications.mention.mail.description',
                    'icon' => 'comment',
                    'push' => [
                        'subject' => 'notifications.mention.mail.subject',
                        'content' => 'notifications.mention.mail.text',
                    ],
                    'fields' => [
                        'title',
                        'content_type',
                    ],
                ],
            ]
        );

        foreach ($notificationTypes as $notificationType) {
            Users::all()->each(
                function ($user) use ($notificationType) {
                    NotificationSubscriber::firstOrCreate(
                        [
                            'user_uuid' => $user->uuid,
                            'notification_type_id' => $notificationType->id,
                        ]
                    );
                }
            );
        }
    }
}
