<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddEventCategoryField extends Migration
{
    public function up(): void
    {
        $bridgeContentType = new \Inside\Host\Bridge\BridgeContentType();

        $bridgeContentType->contentTypeCreateOrUpdateField(
            'spaces',
            'events_category',
            [
                'name' => 'events_category',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 6,
                'title' => [
                    'fr' => 'Catégorie d\'évènements',
                ],
                'description' => [
                    'fr' => 'Choix de la  catégorie d\'évènements à remonter sur l\'espace',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => 6,
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['events_categories'],
                    'cardinality' => 1,
                ],
            ]
        );

        $bridgeContentType->contentTypeDeleteField('node', 'spaces', 'events_categories');
    }
}
