export default {
  globals: {
    calendarExportTypes: [
      {
        type: 'ics',
        label: 'iCalendar'
      }
    ]
  },
  'inside-auth': {
    loginForm: {
      userId: {
        modelName: 'name',
        inputType: 'text'
      }
    }
  },
  'inside-events': {
    bookmarkEnabled: true,
    showBookmarks: true,
    subscriptionEnabled: true
  },
  'inside-ged': {
    useBookmarks: true
  },
  'inside-layouts': {
    gdprContent: 'popins'
  },
  'inside-news': {
    bookmarkEnabled: true,
    dateEnabled: {
      fullPage: true,
      listingComponent: false
    },
  },
  'inside-users': {
    csvImport: true,
    shortcuts: {
      max: 6
    },
    profil: {
      enabledProfilTabs: [
        { name: 'profil', restrictions: [], icon: 'user' },
        { name: 'shortcuts', restrictions: [], icon: 'news' },
        { name: 'bookmarks', restrictions: [], icon: 'bookmark' },
        { name: 'notifications', restrictions: [], icon: 'settings' },
        { name: 'password', restrictions: [] }
      ]
    }
  }
}
