<?php

declare(strict_types=1);

namespace Inside\BOBI\Providers;

use Inside\Support\EventServiceProvider as BaseServiceProvider;
use Psr\Container\ContainerExceptionInterface;
use Psr\Container\NotFoundExceptionInterface;

final class ServiceProvider extends BaseServiceProvider
{
    public function register(): void
    {
        try {
            $this->mergeRecursiveConfigFrom(__DIR__ . '/../../config/scheduler.php', 'scheduler');
            $this->mergeConfigTo(__DIR__ . '/../../config/csv.php', 'csv');
            $this->mergeConfigTo(__DIR__ . '/../../config/xlsx.php', 'xlsx');
        } catch (NotFoundExceptionInterface|ContainerExceptionInterface) {
        }
    }
}
