<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\Users;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;

final class UpdateUsersSendMailValue extends Migration
{
    public function up(): void
    {
        $bridgeContent = new BridgeContent();

        Users::each(function (Users $user) use ($bridgeContent) {
            try {
                $bridgeContent->contentUpdate('users', [
                    'uuid' => $user->uuid,
                    'send_mail' => true,
                ]);
            } catch (Exception $exception) {
                $this->getConsole()->writeln("<error>Error for user $user->uuid ($user->email)</error>");
            }
        });

        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField('users', 'send_mail', [
            'name' => 'send_mail',
            'searchable' => false,
            'translatable' => false,
            'default' => true,
            'search_result_field' => false,
            'required' => false,
            'weight' => 12,
            'title' => [
                'fr' => 'Envoyer un mail à la création de mot de passe',
            ],
            'description' => [
                'fr' => '',
            ],
            'widget' => [
                'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [
                    'display_label' => true,
                ],
                'weight' => 12,
            ],
            'type' => BridgeContentType::BOOLEAN_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
        ]);
    }
}
