<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Migrations\CreateContentTypes;
use Inside\Content\Facades\Schema;
use Illuminate\Support\Facades\DB;

class CreateDga extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        if (!Schema::hasContentType('dga')) {
            $this->bootUp(__FILE__);
            $this->migrateContent('dga', false);
            $this->call('models:rebuild');
            $this->finishUp();
        }

        $bridge = new BridgeContentType();

        if (Schema::hasField('users', 'dga')) {
            $bridge->contentTypeDeleteField(
                entityType: 'user',
                type: 'user',
                fieldName: 'dga',
            );
        }

        $bridge->contentTypeCreateOrUpdateField(
            type: 'users',
            fieldName: 'dga',
            options: [
                'name' => 'dga',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 6,
                'title' => [
                    'fr' => 'DGA',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => 7,
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['dga'],
                    'cardinality' => -1,
                ],
                'selectable_all' => true,
            ],
            weight: 7
        );

        $defaultDga = collect([
            'Cadre de vie et services techniques',
            'Citoyenneté et solidarités',
            'Dynamiques urbaines',
            'Politiques éducatives',
            'Ressources'
        ]);

        $dgaAlreadyExists = DB::table('inside_content_dga')->pluck('title');

        $defaultDga = collect(array_diff($defaultDga->toArray(), $dgaAlreadyExists->toArray()));

        $bridgeContent = new BridgeContent();

        $defaultDga->each(function ($dga) use ($bridgeContent) {
            $bridgeContent->contentInsert(
                type: 'dga',
                data: [
                    'title' => $dga,
                    'code' => $dga,
                ]
            );
        });
    }
}
