<?php

use Illuminate\Support\Collection;
use Inside\User\Models\User;

return [
    'postfilter' => fn (Collection $users) => $users
        ->map(fn (array $record) => collect($record)
            ->map(fn ($value, $key) => match (str($key)->lower()->toString()) {
                'matricule' => str($value)
                    ->replace('\'', '')
                    ->replace('"', '')
                    ->padLeft(7, '0')->toString(),
                default => $value,
            })
            ->filter()
            ->map(fn ($value) => match (str($value)->lower()->toString()) {
                '?', 'pas de boite mail' => null,
                default => $value,
            })
            ->all())
        ->all(),
    'files' => [
        'bobi' => [
            'path' => env('CSV_USERS_PATH', __DIR__.'/../../../../imports/import.csv'),
            'separator' => env('CSV_USERS_SEPARATOR', ','),
            'fields' => [
                'email' => 'email',
                'name' => 'matricule',
                'external_id' => 'matricule',
                'firstname' => 'prenom',
                'lastname' => 'nom',
                'phone' => 'num public',
                'function' => 'fonction',
                'dga' => fn (array $record) => reference('dga')->identifiedBy('code')->from($record['dga'])->get(),
                'services' => fn (array $record) => reference('services')->identifiedBy('code')->from($record['service'])->get(),
                'directions' => fn (array $record) => reference('directions')->identifiedBy('code')->from($record['direction'])->get(),
                'status' => fn () => true,
                'send_mail' => fn (array $record): bool => User::query()->where('email', $record['email'])->doesntExist(),
            ],
            'original_fields' => [
                'email' => 'mail',
                'matricule' => 'word',
                'prenom' => 'firstname',
                'nom' => 'lastname',
                'num public' => 'phone',
                'direction'  => 'word',
                'service'  => 'word',
                'fonction' => 'function',
                'dga' => 'word',
            ],
        ],
    ],
];
