<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

final class CreateImportedContentTypesCodeField extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $importedContentTypes = collect([
            'services',
            'directions',
        ]);

        $this->bootUp(__FILE__);
        $importedContentTypes->each(function (string $contentType) {
            $this->getBridge()?->contentTypeCreateOrUpdateField(
                type: $contentType,
                fieldName: 'code',
                options: [
                    'name' => 'code',
                    'searchable' => false,
                    'translatable' => true,
                    'search_result_field' => false,
                    'searchable_filter' => false,
                    'required' => false,
                    'weight' => 1,
                    'title' => [
                        'fr' => 'Référence d\'import',
                    ],
                    'widget' => [
                        'hidden' => true,
                    ],
                    'type' => BridgeContentType::TEXT_FIELD,
                    'settings' => [
                        'max_length' => 255,
                        'is_ascii' => false,
                        'case_sensitive' => false,
                        'cardinality' => 1,
                    ],
                ]
            );
        });
        $this->finishUp();
    }
}
