import { http } from '@inside-library/helpers/Http'

export default {
  spaces: {
    add: ({ data }) => {
      return {
        name: 'SpacesPage',
        params: {
          slug: data.slug[0]
        }
      }
    },
    globalSearch: async ({ data }) => {
      const { data: spaces } = await http.get('content/spaces', {
        fields: ['uuid', 'title', 'slug'],
        filters: { 'status:eq': 1, 'uuid:eq': data.uuid }
      })

      return {
        route: {
          name: 'SpacesPage',
          params: {
            slug: spaces?.[0]?.slug?.[0]
          }
        }
      }
    }
  },
  pagesCategories: {
    add: async ({ data }) => {
      const { data: category } = await http.get('content/pages_categories', {
        fields: ['uuid', 'title', 'slug', { spaces: { fields: ['slug'] } }],
        filters: { 'status:eq': 1, 'uuid:eq': data.uuid }
      })

      return {
        name: 'SpacesPage',
        params: {
          slug: category?.[0].spaces?.slug?.[0]
        },
        query: {
          tab: data.uuid
        }
      }
    },
    delete: async ({ uuid }) => {
      const { data: pageCategory } = await http.get(
        'content/pages_categories',
        {
          fields: ['uuid', { spaces: ['uuid', 'title', 'slug'] }],
          filters: { 'status:eq': 1, 'uuid:eq': uuid }
        }
      )

      return {
        name: 'SpacesPage',
        params: {
          slug: pageCategory?.[0].spaces?.slug?.[0]
        }
      }
    }
  },
  spacesPages: {
    add: async ({ data }) => {
      const { data: spacesPage } = await http.get('content/spaces_pages', {
        fields: [
          {
            pages_categories: [
              { spaces: { fields: ['uuid', 'title', 'slug'] } }
            ]
          }
        ],
        filters: { 'status:eq': 1, 'uuid:eq': data.uuid }
      })

      return {
        name: 'SpacesPagesPage',
        params: {
          slug: spacesPage?.[0].pages_categories?.spaces?.slug?.[0]
        },
        query: { page: data.uuid }
      }
    },
    delete: async ({ uuid }) => {
      const { data: spacesPage } = await http.get('content/spaces_pages', {
        fields: [
          {
            pages_categories: [
              { spaces: { fields: ['uuid', 'title', 'slug'] } }
            ]
          }
        ],
        filters: { 'status:eq': 1, 'uuid:eq': uuid }
      })

      return {
        name: 'SpacesPagesPage',
        params: {
          slug: spacesPage?.[0].pages_categories?.spaces?.slug?.[0]
        }
      }
    }
  },
  hubs: {
    add: ({ data }) => ({
      name: 'HubsPage',
      params: { slug: data.slug[0] }
    }),
    delete: () => ({
      name: 'HomePage'
    })
  },
  hubsBlockLinks: {
    add: async ({ data }) => {
      const { data: hubsBlockLinksData } = await http.get(
        'content/hubs_block_links',
        {
          fields: [
            'uuid',
            {
              hubs: ['uuid', 'title', 'slug']
            }
          ],
          filters: {
            'status:eq': 1,
            'uuid:eq': data?.uuid
          }
        }
      )

      return {
        name: 'HubsPage',
        params: {
          slug: hubsBlockLinksData?.[0]?.hubs?.data?.[0]?.slug?.[0]
        }
      }
    },
    delete: async ({ data }) => {
      const { data: hubsBlockLinksData } = await http.get(
        'content/hubs_block_links',
        {
          fields: [
            'uuid',
            {
              hubs: ['uuid', 'title', 'slug']
            }
          ],
          filters: {
            'status:eq': 1,
            'uuid:eq': data.uuid
          }
        }
      )

      return {
        name: 'HubsPage',
        params: {
          slug: hubsBlockLinksData?.[0]?.hubs?.data?.[0]?.slug?.[0]
        }
      }
    }
  }
}
