export default {
  'inside-archives': {
    isEnabled: true
  },
  'inside-edition': {
    revisionEnabled: true,
    duplicateEnabled: true
  },
  'inside-events': {
    subscriptionEnabled: true,
    showBookmarks: true,
    bookmarkEnabled: true
  },
  'inside-layouts': {
    tabsPagesBookmarkEnabled: true,
    pagesBookmarkEnabled: true,
    gdprContent: 'popins'
  },
  'inside-newcomers': {
    extraFields: [
      {
        field: 'functions',
        data: data => data.functions?.title
      }
    ]
  },
  'inside-news': {
    bookmarkEnabled: true,
    showBookmarks: true,
    authorEnabled: true
  },
  'inside-organizational-chart': {
    functionKey: 'functions'
  },
  'inside-users': {
    csvImport: true,
    shortcuts: {
      max: 6
    },
    profil: {
      enabledProfilTabs: [
        { name: 'profil', restrictions: [], icon: 'user' },
        { name: 'shortcuts', restrictions: [], icon: 'news' },
        { name: 'bookmarks', restrictions: [], icon: 'bookmark' },
        { name: 'notifications', restrictions: [], icon: 'settings' }
      ]
    },
    paragraphs: {
      fetchedContents: {
        display: () => import('./components/users/UserCard'),
        requestFields: [
          'uuid',
          'firstname',
          'lastname',
          'phone',
          'image',
          { functions: ['title', 'uuid'] }
        ]
      }
    }
  }
}
