<?php

use Inside\Content\Facades\Schema;
use Illuminate\Database\Migrations\Migration;

class TranslateAuthorField extends Migration
{
    public function up(): void
    {
        $fields =
            [
                'fr' => 'Auteur',
                'en' => 'Author',
                'nl' => 'Auteur',
                'pt' => 'Autor',
                'es' => 'Autor',
                'de' => 'Autor',
            ];

        $models = Schema::getModelsWithField('authors');

        collect($models)->each(function ($type) use ($fields) {
            Schema::updateFieldOption($type, 'authors', 'title', $fields);
        });
    }
}
