<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema as InsideSchema;

class FixTranslationFields extends Migration
{
    public function up(): void
    {
        $fields = [
            'tabs' => [
                'tabs_spaces' => [
                    'fr' => 'Espace à onglets',
                    'en' => 'Tabbed space',
                    'nl' => 'Ruimte met tabbladen',
                    'pt' => 'Espaço com guias',
                    'es' => 'Espacio con pestañas',
                    'de' => 'Leerzeichen mit Tabs',
                ],
            ],
            'tabs_pages' => [
                'tabs' => [
                    'fr' => 'Onglets',
                    'en' => 'Tabs',
                    'nl' => 'Tabbladen',
                    'pt' => 'Guias',
                    'es' => 'Cortina a la italiana',
                    'de' => 'Tabs',
                ],
            ],
        ];

        foreach ($fields as $contentType => $field) {
            foreach ($field as $fieldName => $translations) {
                InsideSchema::updateFieldOption($contentType, $fieldName, 'title', $translations);
            }
        }
    }
}
