<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema;
use Inside\Host\Bridge\BridgeContentType;

class UpdateUsersType extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        $this->migrateContent('functions');
        $this->migrateContent('departments');

        if (Schema::hasField('users', 'function')) {
            $this->getBridge()?->contentTypeDeleteField(
                entityType: 'user',
                type: 'user',
                fieldName: 'function',
            );
        }

        if (Schema::hasField('users', 'birthday')) {
            $this->getBridge()?->contentTypeDeleteField(
                entityType: 'user',
                type: 'user',
                fieldName: 'birthday',
            );
        }

        $this->getBridge()?->contentTypeCreateOrUpdateField(
            type: 'users',
            fieldName: 'manager',
            options: [
                'name' => 'manager',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'editable' => false,
                'weight' => 20,
                'title' => [
                    'fr' => 'Manager',
                ],
                'widget' => [
                    'type' => BridgeContentType::AUTOCOMPLETE_WIDGET,
                    'settings' => [],
                    'weight' => 20,
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => 'users',
                    'cardinality' => 1,
                ],
            ],
            weight: 20
        );

        $this->getBridge()?->contentTypeCreateOrUpdateField(
            type: 'users',
            fieldName: 'functions',
            options: [
                'name' => 'functions',
                'type' => BridgeContentType::REFERENCE_FIELD,
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'required' => true,
                'editable' => false,
                'weight' => 3,
                'title' => [
                    'fr' => 'Fonction',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'weight' => 3,
                ],
                'settings' => [
                    'target_type' => ['functions'],
                    'cardinality' => 1,
                ],
            ],
            weight: 3
        );

        $this->getBridge()?->contentTypeCreateOrUpdateField(
            type: 'users',
            fieldName: 'departments',
            options:         [
                'name' => 'departments',
                'type' => BridgeContentType::REFERENCE_FIELD,
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'required' => true,
                'editable' => false,
                'weight' => 10,
                'title' => [
                    'fr' => 'Département',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'weight' => 10,
                ],
                'settings' => [
                    'target_type' => ['departments'],
                    'cardinality' => 1,
                ],
            ],
            weight: 10
        );
    }
}
