<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema;
use Inside\Host\Bridge\BridgeContentType;

class Sid2TranslateContentTypesFields extends Migration
{
    public function up(): void
    {
        $types = [
            "blocks",
            "cards_links",
            "custom",
            "documents",
            "events",
            "events_categories",
            "folders",
            "news",
            "news_categories",
            "tabs",
            "tabs_pages",
            "tabs_spaces",
            "tools",
            "tools_categories",
            "tools_categories_listings",
        ];

        $bridge = new BridgeContentType();
        foreach ($types as $type) {
            $file = __DIR__ . '/../../database/contents/'.$type.'/2025_04_09_000000.php';
            if (file_exists($file)) {
                $content = include($file);
                $fields = $content['fields'];
                foreach ($fields as $field) {
                    $bridge->changeFieldTitle($type, $field['name'], $field['title'], 'node');
                }
            }
        }
    }
}
