<?php

use Illuminate\Support\Arr;
use Illuminate\Support\Collection;
use Inside\Host\Bridge\BridgeContent;

return [
    'postfilter' => function (Collection $users): Collection {
        return $users->filter(fn (mixed $user) => $user->accountEnabled);
    },
    'sync_attributes' => [
        'mail' => 'mail',
        'name' => 'mail',
        'image' => 'photo',
        'lastname' => 'surname',
        'firstname' => 'givenName',
        'phone' => 'mobilePhone',
        'functions' => fn (mixed $user) => reference('functions')->identifiedBy('code')->from($user->jobTitle)->get(),
        'departments' => fn (mixed $user) => reference('departments')->identifiedBy('code')->from($user->department)->get(),
        'manager' => fn (mixed $user) => reference('users')->identifiedBy('email')->from($user->manager)->withoutCreation()->get(),
        'status' => fn () => true,
        'is_maintenance' => fn () => false,
    ],
    'custom_attributes' => [
        'manager' => 'mail',
    ],
];
