import SpacesPage from '../pages/spaces/SpacesPage'
import SpacesPagesPage from '../pages/spaces/SpacesPagesPage'
import { fetchSpacesPage, fetchSpacesPagesPage } from '../fetch/spaces'

import CrossSellingFullPage from '../pages/cross-selling/CrossSellingFullPage'
import { fetchCrossSellingFullPage } from '../fetch/cross-selling'

import VacationsFormPage from '../pages/vacations/VacationsFormPage'
import { fetchVacationsPage } from '../fetch/vacations'

import SupportPage from '../pages/support/SupportPage'
import { fetchSupportPage } from '../fetch/support'

import AdminAdvancedSettingsHomePage from '../pages/advanced-settings/AdminAdvancedSettingsHomePage'
import AdminAdvancedSettingsIdentityPage from '../pages/advanced-settings/AdminAdvancedSettingsIdentityPage'
import { fetchSettings } from '@inside-administration/fetch'

import { withFetch } from 'inside-collection/hocs'

export default [
  {
    name: 'HomePage',
    component: () => import('../pages/HomePage'),
    meta: { disabled: false }
  },
  {
    name: 'NewsListingPage',
    props: {
      extraCategoriesFields: [
        {
          brands: {
            fields: ['uuid', 'title'],
            filters: { 'status:eq': 1, sort: 'title:asc' }
          }
        }
      ]
    },
    meta: { disabled: false }
  },
  {
    name: 'NewsPage',
    props: {
      extraFields: [{ brands: ['uuid', 'title'] }],
      contentOptions: {
        extraCategoriesConfig: {
          brands: {
            data: (data, contentType, { getData }) =>
              getData(data, contentType),
            href: ({ uuid }) => ({
              name: 'NewsListingPage',
              query: { brands: uuid }
            })
          }
        }
      },
      relatedOptions: {
        extraFields: [{ brands: ['title', 'uuid'] }],
        componentAttributes: () => ({
          extraCategoriesConfig: {
            brands: {
              data: (data, contentType, { getData }) =>
                getData(data, contentType),
              disabledOn: ['NewsListingPage'],
              href: ({ uuid }) => ({
                name: 'NewsListingPage',
                query: { brands: uuid }
              })
            }
          }
        })
      }
    },
    meta: { disabled: false }
  },
  {
    name: 'BetweenNewsListingPage',
    path: '/entre-vous-nous',
    component: () => import('@inside-news/components/pages/ListingPage'),
    props: {
      filters: [],
      contentRoot: {
        between_news: item => ({
          name: 'BetweenNewsPage',
          params: { slug: item.slug[0] }
        })
      }
    }
  },
  {
    name: 'BetweenNewsPage',
    path: '/entre-vous-nous/:slug',
    component: () => import('@inside-news/components/pages/NewsPage'),
    props: {
      contentType: 'between_news',
      fieldsContentType: 'news',
      configModule: 'inside-customs',
      back: { href: { name: 'BetweenNewsListingPage' } }
    }
  },
  {
    name: 'CapTempoNewsListingPage',
    path: '/cap-tempo',
    component: () => import('@inside-news/components/pages/ListingPage'),
    props: {
      bannerData: {
        page: 'cap-tempo'
      },
      filters: [],
      extraRequestFilters: { brands: { 'slug:eq': 'cap-tempo' } },
      extraCategoriesFields: [
        {
          brands: {
            fields: ['uuid', 'title'],
            filters: { 'status:eq': 1, sort: 'title:asc' }
          }
        }
      ]
    },
    meta: { disabled: false }
  },
  {
    name: 'DirectoryPage',
    component: () => import('../pages/directory/DirectoryPage'),
    meta: { disabled: false }
  },
  {
    name: 'GedPage',
    meta: { disabled: false },
    props: {
      cardOverlayEnabled: false,
      extraFilters: {
        sort: 'weight:asc'
      }
    }
  },
  {
    name: 'SpacesPage',
    path: '/espace/:slug',
    component: withFetch(SpacesPage, { size: 'xxl' })(fetchSpacesPage),
    meta: { content: 'spaces' }
  },
  {
    name: 'SpacesPagesPage',
    path: '/espace/:slug/:page',
    component: withFetch(SpacesPagesPage, { size: 'xxl' })(
      fetchSpacesPagesPage
    ),
    meta: { content: 'rh_spaces' }
  },
  {
    name: 'JobsListingPage',
    path: '/offres-d-emploi',
    component: () => import('../pages/jobs/JobsListingPage')
  },
  {
    name: 'CrossSellingPage',
    path: '/mes-deals',
    component: () => import('../pages/cross-selling/CrossSellingPage')
  },
  {
    name: 'CrossSellingFormPage',
    path: '/proposer-un-lead',
    component: () => import('../pages/cross-selling/CrossSellingFormPage')
  },
  {
    name: 'CrossSellingAdminPage',
    path: '/tous-les-lead',
    component: () => import('../pages/cross-selling/CrossSellingAdminPage')
  },
  {
    name: 'CrossSellingFullPage',
    path: '/lead/:slug',
    component: withFetch(CrossSellingFullPage, { size: 'xxl' })(
      fetchCrossSellingFullPage
    )
  },
  {
    name: 'CooptionFormPage',
    path: '/cooptation',
    component: () => import('../pages/cooption/CooptionFormPage')
  },
  {
    name: 'CooptionListingPage',
    path: '/cooptation/gestion',
    component: () => import('../pages/cooption/CooptionListingPage'),
    props: {
      page: 'cooption-listing'
    }
  },
  {
    name: 'CooptionAdminListingPage',
    path: '/cooptation/administration',
    component: () => import('../pages/cooption/CooptionListingPage'),
    props: {
      page: 'cooption-listing-admin'
    }
  },
  {
    name: 'LeaveRequestFormPage',
    path: '/conges',
    component: withFetch(VacationsFormPage, { size: 'xxl' })(fetchVacationsPage)
  },
  {
    name: 'LeavesListingPage',
    path: '/conges/consulter',
    component: () => import('../pages/vacations/VacationsListingPage')
  },
  {
    name: 'LeavesAdminPage',
    path: '/conges/gerer',
    component: () => import('../pages/vacations/VacationsValidationPage')
  },
  {
    name: 'LeavesValidationPage',
    path: '/conges/validation',
    component: () => import('../pages/vacations/VacationsAdminPage')
  },
  {
    name: 'ToolsPage',
    meta: { disabled: false }
  },
  {
    name: 'SupportListingPage',
    path: '/support',
    component: () => import('../pages/support/SupportListingPage')
  },
  {
    name: 'SupportPage',
    path: '/support/:slug',
    component: withFetch(SupportPage, { size: 'xxl' })(fetchSupportPage)
  },
  {
    name: 'SimplePage',
    meta: { disabled: false }
  },
  {
    name: 'AdminAdvancedSettingsHomePage',
    component: withFetch(AdminAdvancedSettingsHomePage, { size: 'xxl' })(
      fetchSettings
    ),
    meta: { admin: true, display: true }
  },
  {
    name: 'AdminAdvancedSettingsIdentityPage',
    component: withFetch(AdminAdvancedSettingsIdentityPage, { size: 'xxl' })(
      fetchSettings
    ),
    meta: { admin: true, display: true }
  }
]
