import { http } from '@inside-library/helpers/Http'

export default {
  spaces: {
    add: ({ data }) => ({
      name: 'SpacesPage',
      params: { slug: data.slug[0] }
    })
  },
  spacesPagesCategories: {
    fields: [{ spaces: ['slug'] }],
    add: ({ data }) => ({
      name: 'SpacesPage',
      params: { slug: data.spaces.data[0].slug[0] }
    }),
    delete: ({ data }) => ({
      name: 'SpacesPage',
      params: { slug: data.spaces.data[0].slug[0] }
    })
  },
  spacesPages: {
    fields: ['uuid', { spaces_pages_categories: [{ spaces: ['slug'] }] }],
    add: ({ data }) => ({
      name: 'SpacesPagesPage',
      params: {
        slug: data.spaces_pages_categories.data[0].spaces.data[0].slug[0],
        page: data.slug[0]
      }
    }),
    delete: ({ data }) => ({
      name: 'SpacesPage',
      params: {
        slug: data.spaces_pages_categories.data[0].spaces.data[0].slug[0]
      }
    }),
    globalSearch: async ({ data }) => {
      const { data: spacesPagesCategories } = await http.get(
        'content/spaces_pages',
        {
          fields: ['uuid', { spaces_pages_categories: ['uuid', 'title'] }],
          filters: { 'uuid:eq': data.uuid }
        }
      )

      const { data: space } = await http.get(
        'content/spaces_pages_categories',
        {
          fields: ['uuid', { spaces: ['uuid', 'title', 'slug'] }],
          filters: {
            'uuid:eq':
              spacesPagesCategories[0].spaces_pages_categories.data[0].uuid
          }
        }
      )

      return {
        route: {
          name: 'SpacesPagesPage',
          params: {
            slug: space[0].spaces.data[0].slug[0],
            page: data.slug[0]
          }
        }
      }
    }
  },
  jobs: {
    add: () => ({
      name: 'JobsListingPage'
    }),
    delete: () => ({
      name: 'JobsListingPage'
    })
  },
  jobsContracts: {
    extends: 'jobs'
  },
  supportsPages: {
    add: ({ data }) => ({
      name: 'SupportPage',
      params: { slug: data.slug[0] }
    }),
    delete: () => ({
      name: 'SupportListingPage'
    })
  }
}
