import { http } from '@inside-library/helpers/Http'

export const fetchSpacesPage = async ({ $route }) => {
  try {
    const { data } = await http.get('content/spaces', {
      fields: [
        'uuid',
        'title',
        'banner',
        'introduction',
        'admin',
        'content_type',
        {
          users: {
            fields: [
              'uuid',
              'image',
              'firstname',
              'lastname',
              'function',
              'phone',
              'email',
              { brands: ['uuid', 'title'] }
            ],
            filters: {
              'status:eq': 1
            }
          }
        }
      ],
      filters: { 'slug:eq': $route.params.slug }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

export const fetchSpacesPagesPage = async ({ $route }) => {
  try {
    const { data } = await http.get('content/spaces_pages', {
      fields: [
        'uuid',
        'title',
        'content',
        'admin',
        'content_type',
        {
          spaces_pages_categories: {
            fields: ['uuid', 'title'],
            filters: {
              'status:eq': 1
            }
          }
        }
      ],
      filters: { 'slug:eq': $route.params.page }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}
