import { onMounted } from 'vue'
import { getAppInstance } from '@inside-core/helpers/getAppInstance'

import JobModal from '../components/jobs/JobModal'
import VacationModal from '../components/vacations/VacationModal'
import CooptionModal from '../components/cooptions/CooptionModal'

export function useGlobalComponents() {
  const app = getAppInstance()

  onMounted(() => {
    app.component('job-modal', JobModal)
    app.component('vacation-modal', VacationModal)
    app.component('cooption-modal', CooptionModal)
  })
}
