import moment from 'moment'

import { insertIf } from '@inside-library/helpers/Arrays'

export default {
  data() {
    return {
      m_currentStartDate: null,
      m_currentEndDate: null
    }
  },
  computed: {
    $_today() {
      return moment().set({ h: 23, m: 59 })
    },
    $_yesterday() {
      return moment()
        .set({ h: 23, m: 59 })
        .subtract(1, 'd')
        .toDate()
    },
    $_startDate() {
      return moment(this.m_currentStartDate).set({ h: 23, m: 59 })
    },
    $_endDate() {
      return moment(this.m_currentEndDate).set({ h: 23, m: 59 })
    },
    $_disabledStartDate() {
      if (this.$_endDate.isSame(this.$_today, 'd')) {
        return {
          to: this.$_yesterday,
          from: this.$_endDate.toDate()
        }
      }

      return {
        to: this.$_yesterday,
        ...(this.m_currentEndDate && {
          from: this.$_endDate.toDate()
        })
      }
    },
    $_disabledEndDate() {
      return {
        to: this.m_currentStartDate
          ? this.$_startDate.subtract(1, 'd').toDate()
          : this.$_yesterday
      }
    },
    $_highlighted() {
      if (this.m_currentStartDate && this.m_currentEndDate) {
        return {
          from: this.$_startDate.toDate(),
          to: this.$_endDate.toDate()
        }
      } else {
        return {
          dates: [
            ...insertIf(this.m_currentStartDate, this.$_startDate.toDate()),
            ...insertIf(this.m_currentEndDate, this.$_endDate.toDate())
          ]
        }
      }
    }
  }
}
