export default {
  computed: {
    $_admins() {
      const value = this.getCheckedData(this.heritedOptions, [
        'custom',
        'admin'
      ])

      try {
        return value ? JSON.parse(value) : []
      } catch {
        return []
      }
    },
    $_isAdmin() {
      const roles = this.getUserInfos.permissions.roles

      return (
        this.$_admins.some(item => roles.includes(item)) || this.isSuperAdmin
      )
    }
  }
}
