import { getAppInstance } from '@inside-core/helpers/getAppInstance'
import { http } from '@inside-library/helpers/Http'

const fetchVacationsPage = async ({ $route }) => {
  const app = getAppInstance()

  const imageKey = app.config.globalProperties.$_getConfig(
    'banner.imageKey',
    'inside-commons'
  )

  try {
    const { data } = await http.get('content/custom', {
      fields: [
        'uuid',
        'title',
        'introduction',
        'admin',
        'content_type',
        imageKey
      ],
      filters: { 'custom_slug:eq': $route.meta.customSlug }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

export { fetchVacationsPage }
