import { http } from '@inside-library/helpers/Http'

export const fetchSupportPage = async ({ $route }) => {
  try {
    const { data } = await http.get('content/supports_pages', {
      fields: ['uuid', 'title', 'content', 'uuid', 'content_type', 'admin'],
      filters: { 'slug:eq': $route.params.slug }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}
