import { http } from '@inside-library/helpers/Http'

export const fetchCrossSellingFullPage = async ({ $route }) => {
  try {
    const { data } = await http.get('content/leads', {
      fields: [
        'uuid',
        'title',
        'number',
        'email',
        'customer',
        'evaluation',
        'probability',
        'amount_invoiced',
        'needs_place',
        'needs_type',
        'name',
        'phone',
        'note',
        {
          authors: {
            fields: ['uuid', 'firstname', 'lastname']
          }
        },
        {
          leads_status: {
            fields: ['uuid', 'title', 'color'],
            filters: {
              'status:eq': 1
            }
          }
        },
        {
          delivery: {
            fields: ['uuid', 'firstname', 'lastname'],
            filters: {
              'status:eq': 1
            }
          }
        }
      ],
      filters: { 'slug:eq': $route.params.slug }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}
