export default {
  cooptions: {
    extendedUrl: ['uuid'],
    editionDisabled: true,
    modalFields: [
      'uuid',
      'firstname',
      'lastname',
      'message',
      'file',
      'published_at',
      { authors: ['firstname', 'lastname', 'uuid'] },
      { cooptions_status: ['uuid'] }
    ]
  },
  jobs: {
    modalFields: [
      'uuid',
      'title',
      'content',
      'email',
      'salary',
      'region',
      'job',
      'mission_duration',
      { brands: ['title'] },
      { jobs_contracts: ['title'] }
    ]
  },
  leads: {
    editionDisabled: true,
    modalFields: [
      'uuid',
      'title',
      'number',
      'customer',
      'email',
      'complements',
      'needs_place',
      'needs_type',
      'amount_invoiced',
      'name',
      'probability',
      'phone',
      'evaluation',
      { delivery: ['uuid', 'image', 'lastname', 'firstname'] },
      { leads_status: ['uuid'] },
      { authors: ['uuid'] }
    ]
  },
  users: {
    extendedUrl: ['uuid'],
    modalFields: [
      'uuid',
      'firstname',
      'lastname',
      'image',
      'is_vacations',
      'function',
      'email',
      'phone',
      'mobile',
      'department',
      { domains: ['title'] },
      { brands: ['title'] },
      { agencies: ['title'] }
    ]
  },
  vacations: {
    extendedUrl: ['uuid'],
    editionDisabled: true,
    modalFields: [
      'title',
      'uuid',
      'date_start',
      'date_end',
      'comment',
      'uuid',
      'days_count',
      'published_at',
      { date_start_duration: ['title'] },
      { date_end_duration: ['title'] },
      { authors: ['uuid', 'image', 'firstname', 'lastname'] },
      { validator: ['uuid', 'image', 'firstname', 'lastname'] },
      { vacations_status: ['uuid'] },
      { vacations_categories: ['uuid', 'title'] }
    ]
  },
  tools: {
    modalFields: ['uuid', 'title', 'content', 'file', 'link', 'icon', 'image']
  }
}
