<?php

namespace Inside\BELV\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Support\Collection;
use Inside\Authentication\Models\User;
use Inside\Content\Events\CommentCreatedEvent;
use Inside\Notify\Listeners\BaseNotificationListener;
use Inside\Notify\Models\NotificationType;

class LeadsCommentCreatedListener extends BaseNotificationListener implements ShouldQueue
{
    public function handle(CommentCreatedEvent $event): void
    {
        $parent = $event->parent;
        $comment = $event->comment;

        if ($parent->content_type != 'leads') {
            return;
        }


        /** @var Collection<string> $targets */
        $targets = User::whereHas(
            'roles',
            function ($query) {
                return $query->where('inside_roles.name', 'Admin ventes-croisées');
            }
        )
            ->orWhereIn('uuid', $parent->delivery->pluck('uuid'))
            ->pluck('uuid');

        /** @var Collection<NotificationType> $notificationTypes */
        $notificationTypes = NotificationType::where('action', 'leadsCommentCreated')->get();
        foreach ($notificationTypes as $notificationType) {
            foreach ($targets as $target) {
                if ($target === $comment->author) {
                    continue;
                }

                /** @var ?User $target */
                $target = User::find($target);
                $this->route = $target;
                $this->notify(
                    $notificationType,
                    $target,
                    $parent,
                    [
                        'from' => $comment->author,
                        'comment' => $comment,
                        'url' => $parent->slug[0] ?? ''.'#&d/'.$comment->uuid,
                    ]
                );
            }
        }
    }
}
