<?php

namespace Inside\BELV\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Support\Collection;
use Inside\Authentication\Models\User;
use Inside\BELV\Helpers\UrlHelper;
use Inside\Content\Events\ContentSynchedEvent;
use Inside\Notify\Listeners\BaseNotificationListener;
use Inside\Notify\Models\NotificationType;

class CooptionsUpdatedListener extends BaseNotificationListener implements ShouldQueue
{
    public function handle(ContentSynchedEvent $event): void
    {
        $model = $event->model;
        $fieldName = $event->fieldName;
        $user = $event->user;

        if (
            $model->content_type != 'cooptions'
            || $fieldName !== 'cooptions_status'
            || !$user instanceof User
        ) {
            return;
        }

        /** @var ?User $targetUser */
        $targetUser = User::find($model->author);

        if ($targetUser instanceof User && $targetUser->uuid === $user->uuid) {
            return;
        }

        $status = $model->cooptionsStatus->first()->title;
        /** @var Collection<NotificationType> $notificationTypes */
        $notificationTypes = NotificationType::where('model', type_to_class($model->content_type))
            ->where('action', 'statusUpdated')
            ->get();
        $this->route = $targetUser;
        foreach ($notificationTypes as $notificationType) {
            $this->when = $this->getInterval($notificationType);
            $this->notify(
                $notificationType,
                $targetUser,
                $model,
                [
                    'from' => $user->uuid,
                    'cooption_status' => $status,
                    'url' => UrlHelper::getModalUrl('gestion-cooptations', $model),
                ]
            );
        }
    }
}
