<?php

namespace Inside\BELV\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Support\Collection;
use Inside\Authentication\Models\User;
use Inside\Content\Events\ContentCreatedEvent;
use Inside\BELV\Helpers\UrlHelper;
use Inside\Notify\Listeners\BaseNotificationListener;
use Inside\Notify\Models\NotificationType;

class CooptionsCreatedListener extends BaseNotificationListener implements ShouldQueue
{
    public function handle(ContentCreatedEvent $event): void
    {
        $model = $event->model;

        if ($model->content_type != 'cooptions') {
            return;
        }

        /** @var Collection<NotificationType> $notificationTypes */
        $notificationTypes = NotificationType::where('model', type_to_class($model->content_type))
            ->where('action', 'create')
            ->get();

        $cooptionsAdmins = User::whereHas(
            'roles',
            function ($query) {
                return $query->where('inside_roles.name', 'service RH');
            }
        )->pluck('uuid');

        foreach ($cooptionsAdmins as $userUuid) {
            if ($userUuid === $model->author) {
                continue;
            }

            /** @var ?User $user */
            $user = User::find($userUuid);
            $this->route = $user;
            foreach ($notificationTypes as $notificationType) {
                $this->when = $this->getInterval($notificationType);
                $this->notify($notificationType, $user, $model, ['from' => $model->author, 'url' => UrlHelper::getModalUrl('cooptation-admin', $model)]);
            }
        }
    }
}
