<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\Brands;
use Inside\Host\Bridge\BridgeContent;

class AddIttakaDomain extends Migration
{
    public function up(): void
    {
        $brands = Brands::where('title', 'Ittaka')
            ->pluck('uuid')
            ->toArray();

        $bridge = new BridgeContent();
        $bridge->contentInsert(
            'domains',
            [
                'bundle' => 'domains',
                'type' => 'node',
                'title' => 'ittaka.fr',
                'brands' => $brands,
            ]
        );
    }

    public function down(): void
    {
    }
}
