<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\BetweenNews;
use Inside\Content\Models\Contents\News;
use Inside\Host\Bridge\BridgeContent;

class ConvertBetweenNewsToNews extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContent();
        $betweenNewsContents = BetweenNews::get();

        foreach ($betweenNewsContents as $betweenNewsContent) {
            if (News::where('title', $betweenNewsContent->title)->exists()) {
                continue;
            }

            $newsUuid = $bridge->contentInsert('news', [
                'title' => $betweenNewsContent->title,
                'status' => $betweenNewsContent->status,
                'chapo' => $betweenNewsContent->chapo,
                'image' => $betweenNewsContent->image,
                'news_categories' => $betweenNewsContent->newsCategories->pluck('uuid')->toArray(),
                'brands' => $betweenNewsContent->brands->pluck('uuid')->toArray()
            ]);
            if ($newsUuid) {
                $bridge->contentUpdate('news', [
                    'uuid' => $newsUuid,
                    'created_at' => date("Y-m-d H:i:s", $betweenNewsContent->created_at),
                    'author' => $betweenNewsContent->author
                ]);
            }
        }
    }

    public function down(): void
    {
    }
}
