<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Str;
use Inside\Content\Models\Contents\Users;
use Inside\Host\Bridge\BridgeContent;

class RemoveIsMaintenance extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContent();
        $users = Users::where('is_maintenance', 1)
            ->get();

        foreach ($users as $user) {
            if (!Str::contains($user->email, '@maecia.com')) {
                $bridge->contentUpdate('users', ['is_maintenance' => 0, 'uuid_host' => $user->uuid_host]);
            }
        }
    }

    public function down(): void
    {
    }
}
