<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddBrandsFieldForVacationContentType extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();
        $bridge->contentTypeCreateOrUpdateField(
            'vacations',
            'brands',
            [
                'name' => 'brands',
                'type' => BridgeContentType::REFERENCE_FIELD,
                'searchable' => true,
                'translatable' => false,
                'search_result_field' => false,
                'required' => false,
                'weight' => 3,
                'title' => [
                    'fr' => 'Marque',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                ],
                'settings' => [
                    'target_type' => 'brands',
                    'cardinality' => 1,
                ],
            ],
            3
        );
    }

    public function down(): void
    {
    }
}
