<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;
use Inside\Notify\Models\NotificationType;

class AddCooptionsNotificationTypes extends Migration
{
    use CreateContentTypes;

    /**
     * @var BridgeContentType $bridge
     */
    protected $bridge;

    public function up(): void
    {
        $notificationTypes = [];

        // création cooptations
        $notificationTypes[] = NotificationType::firstOrCreate(
            [
                'via' => 'web',
                'default' => false,
                'event' => 'Inside\Content\Events\ContentCreatedEvent',
                'model' => 'Inside\Content\Models\Contents\Cooptions',
                'action' => 'create',
                'condition' => '!author:CURRENT_USER',
                'multiple' => false,
                'language' => false,
                'profile' => false,
            ],
            [
                'data' => [
                    'title' => 'notifications.create.content.cooptions.title',
                    'description' => 'notifications.create.content.cooptions.description',
                    'icon' => 'news',
                    'text' => 'notifications.create.content.cooptions.text',
                    'fields' => [],
                    'url' => 'cooptation-admin',
                ],
            ]
        );

        $notificationTypes[] = NotificationType::firstOrCreate(
            [
                'via' => 'email',
                'default' => false,
                'event' => 'Inside\Content\Events\ContentCreatedEvent',
                'model' => 'Inside\Content\Models\Contents\Cooptions',
                'action' => 'create',
                'condition' => '!author:CURRENT_USER',
                'multiple' => false,
                'language' => false,
                'profile' => false,
            ],
            [
                'data' => [
                    'title' => 'notifications.create.content.cooptions.title',
                    'description' => 'notifications.create.content.cooptions.description',
                    'icon' => 'news',
                    'text' => 'notifications.create.content.cooptions.text',
                    'mail' => [
                        'subject' => 'notifications.create.content.cooptions.mail.subject',
                        'text' => 'notifications.create.content.cooptions.mail.text',
                        'buttonText' => 'notifications.create.content.cooptions.mail.buttonText',
                    ],
                    'fields' => [],
                    'url' => 'cooptation-admin',
                ],
            ]
        );

        // Réponse cooptations
        $notificationTypes[] = NotificationType::firstOrCreate(
            [
                'via' => 'web',
                'default' => false,
                'event' => 'Inside\Content\Events\ContentSynchedEvent',
                'model' => 'Inside\Content\Models\Contents\Cooptions',
                'action' => 'statusUpdated',
                'condition' => '!author:CURRENT_USER',
                'multiple' => false,
                'language' => false,
                'profile' => false,
            ],
            [
                'data' => [
                    'title' => 'notifications.create.content.cooptions.status.updated.title',
                    'description' => 'notifications.create.content.cooptions.status.updated.description',
                    'icon' => 'news',
                    'text' => 'notifications.create.content.cooptions.status.updated.text',
                    'fields' => [],
                    'url' => 'cooptation-admin',
                ],
            ]
        );

        $notificationTypes[] = NotificationType::firstOrCreate(
            [
                'via' => 'email',
                'default' => false,
                'event' => 'Inside\Content\Events\ContentSynchedEvent',
                'model' => 'Inside\Content\Models\Contents\Cooptions',
                'action' => 'statusUpdated',
                'condition' => '!author:CURRENT_USER',
                'multiple' => false,
                'language' => false,
                'profile' => false,
            ],
            [
                'data' => [
                    'title' => 'notifications.create.content.cooptions.status.updated.title',
                    'description' => 'notifications.create.content.cooptions.status.updated.description',
                    'icon' => 'news',
                    'text' => 'notifications.create.content.cooptions.status.updated.text',
                    'mail' => [
                        'subject' => 'notifications.create.content.cooptions.status.updated.mail.subject',
                        'text' => 'notifications.create.content.cooptions.status.updated.mail.text',
                        'buttonText' => 'notifications.create.content.cooptions.mail.buttonText',
                    ],
                    'fields' => [],
                    'url' => 'cooptation-admin',
                ],
            ]
        );
    }

    public function down(): void
    {
    }
}
