<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Config;
use Inside\Content\Models\Contents\Domains;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;

class AddBrandsInDomains extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField('domains', 'brands', [
            'name' => 'brands',
            'type' => BridgeContentType::REFERENCE_FIELD,
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => true,
            'title' => [
                'fr' => 'Marque',
            ],
            'widget' => [
                'type' => BridgeContentType::OPTIONS_BUTTONS_WIDGET,
            ],
            'settings' => [
                'target_type' => ['brands'],
                'cardinality' => 1,
            ],
        ]);
    }

    public function down(): void
    {
    }
}
