<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class ChangeWrongFieldsMigration extends Migration
{
    /**
     * @var BridgeContentType
     */
    private $bridgeContentType;

    /**
     * @var array
     */
    private $contentTypesFields = [
        'vacations_status' => [
            [
                'name' => 'value',
                'type' => BridgeContentType::TEXT_FIELD,
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'required' => false,
                'title' => [
                    'fr' => 'Valeur machine (accepted|declined|pending)',
                ],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                    'settings' => [],
                ],
                'settings' => [
                    'cardinality' => 1,
                ],
            ],
        ],
        'leads_status' => [
            [
                'name' => 'value',
                'type' => BridgeContentType::TEXT_FIELD,
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'required' => false,
                'title' => [
                    'fr' => 'Valeur machine (accepted|declined|pending)',
                ],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                    'settings' => [],
                ],
                'settings' => [
                    'cardinality' => 1,
                ],
            ],
        ],
    ];

    public function __construct()
    {
        $this->bridgeContentType = new BridgeContentType();
    }

    public function up(): void
    {
        foreach ($this->contentTypesFields as $contentType => $fields) {
            foreach ($fields as $field) {
                $this->bridgeContentType->contentTypeCreateOrUpdateField($contentType, $field['name'], $field);
            }
        }
    }

    public function down(): void
    {
    }
}
