<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;
use Inside\Notify\Models\NotificationType;

class AddVacationsNotificationTypes extends Migration
{
    use CreateContentTypes;

    /**
     * @var BridgeContentType $bridge
     */
    protected $bridge;

    public function up(): void
    {
        $notificationTypes = [];

        // création demande de congés
        $notificationTypes[] = NotificationType::firstOrCreate(
            [
                'via' => 'web',
                'default' => true,
                'event' => 'Inside\Content\Events\ContentCreatedEvent',
                'model' => 'Inside\Content\Models\Contents\Vacations',
                'action' => 'create',
                'condition' => '!author:CURRENT_USER',
                'multiple' => false,
                'language' => false,
                'profile' => true,
                'data' => [
                    'title' => 'notifications.create.content.vacations.title',
                    'description' => 'notifications.create.content.vacations.description',
                    'icon' => 'news',
                    'text' => 'notifications.create.content.vacations.text',
                    'fields' => [],
                ],
            ]
        );

        $notificationTypes[] = NotificationType::firstOrCreate(
            [
                'via' => 'email',
                'default' => true,
                'event' => 'Inside\Content\Events\ContentCreatedEvent',
                'model' => 'Inside\Content\Models\Contents\Vacations',
                'action' => 'create',
                'condition' => '!author:CURRENT_USER',
                'multiple' => false,
                'language' => false,
                'profile' => true,
                'data' => [
                    'title' => 'notifications.create.content.vacations.title',
                    'description' => 'notifications.create.content.vacations.description',
                    'icon' => 'news',
                    'text' => 'notifications.create.content.vacations.text',
                    'mail' => [
                        'subject' => 'notifications.create.content.vacations.mail.subject',
                        'text' => 'notifications.create.content.vacations.mail.text',
                        'buttonText' => 'notifications.create.content.vacations.mail.buttonText'
                    ],
                    'fields' => [],
                ],
            ]
        );

        // Réponse demande de congés
        $notificationTypes[] = NotificationType::firstOrCreate(
            [
                'via' => 'web',
                'default' => true,
                'event' => 'Inside\Content\Events\ContentSynchedEvent',
                'model' => 'Inside\Content\Models\Contents\Vacations',
                'action' => 'statusUpdated',
                'condition' => '!author:CURRENT_USER',
                'multiple' => false,
                'language' => false,
                'profile' => true,
                'data' => [
                    'title' => 'notifications.create.content.vacations.status.updated.title',
                    'description' => 'notifications.create.content.vacations.status.updated.description',
                    'icon' => 'news',
                    'text' => 'notifications.create.content.vacations.status.updated.<vacations_status>.text',
                    'fields' => [
                        'status'
                    ],
                ],
            ]
        );

        $notificationTypes[] = NotificationType::firstOrCreate(
            [
                'via' => 'email',
                'default' => true,
                'event' => 'Inside\Content\Events\ContentSynchedEvent',
                'model' => 'Inside\Content\Models\Contents\Vacations',
                'action' => 'statusUpdated',
                'condition' => '!author:CURRENT_USER',
                'multiple' => false,
                'language' => false,
                'profile' => true,
                'data' => [
                    'title' => 'notifications.create.content.vacations.status.updated.title',
                    'description' => 'notifications.create.content.vacations.status.updated.description',
                    'icon' => 'news',
                    'text' => 'notifications.create.content.vacations.status.updated.text',
                    'mail' => [
                        'subject' => 'notifications.create.content.vacations.status.updated.<vacations_status>.mail.subject',
                        'text' => 'notifications.create.content.vacations.status.updated.<vacations_status>.mail.text',
                        'buttonText' => 'notifications.create.content.vacations.mail.buttonText'
                    ],
                    'fields' => [
                        'status'
                    ],
                ],
            ]
        );
    }

    public function down(): void
    {
    }
}
