<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddMissingFieldsMigration extends Migration
{
    /**
     * @var BridgeContentType
     */
    private $bridgeContentType;

    /**
     * @var array
     */
    private $contentTypesFields = [
        'between_news' => [
            [
                'name' => 'news_categories',
                'type' => BridgeContentType::REFERENCE_FIELD,
                'searchable' => true,
                'translatable' => false,
                'search_result_field' => false,
                'required' => true,
                'title' => [
                    'fr' => 'Categories d\'actualités',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                ],
                'settings' => [
                    'target_type' => ['news_categories'],
                    'cardinality' => -1,
                ],
            ],
        ],
    ];

    public function __construct()
    {
        $this->bridgeContentType = new BridgeContentType();
    }

    public function up(): void
    {
        foreach ($this->contentTypesFields as $contentType => $fields) {
            foreach ($fields as $field) {
                $this->bridgeContentType->contentTypeCreateOrUpdateField($contentType, $field['name'], $field);
            }
        }
    }

    public function down(): void
    {
    }
}
