<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

class ContentsTypesMigration extends Migration
{
    use CreateContentTypes;

    private const CONTENT_TYPES = [
        'brands',
        'jobs_contracts',
        'jobs',
        'between_news',
        'cooptions_status',
        'cooptions',
        'folders',
        'documents',
        'domains',
        'leads_status',
        'leads',
        'newcomers',
        'news_categories',
        'news',
        'pages',
        'spaces',
        'spaces_pages_categories',
        'spaces_pages',
        'support_pages',
        'tools_categories',
        'tools',
        'vacations_durations',
        'vacations_status',
        'vacations'
    ];

    public function up(): void
    {
        $this->bootUp(__FILE__);

        foreach (self::CONTENT_TYPES as $contentType) {
            $this->migrateContent($contentType);
        }

        $this->finishUp();
    }

    public function down(): void
    {
        $this->bridge = new BridgeContentType();

        foreach (self::CONTENT_TYPES as $contentType) {
            $this->bridge->contentTypeDelete($contentType);
        }
    }
}
