<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'vacations',
    ],
    'fields' => [
        [
            'name' => 'vacations_categories',
            'type' => BridgeContentType::REFERENCE_FIELD,
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => false,
            'required' => true,
            'title' => [
                'fr' => 'Type de congés',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
            ],
            'settings' => [
                'target_type' => ['vacations_categories'],
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'days_count',
            'type' => BridgeContentType::FLOAT_FIELD,
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => true,
            'title' => [
                'fr' => 'Nombre de jours (1 jour = 7h)',
            ],
            'widget' => [
                'type' => BridgeContentType::NUMBER_WIDGET,
                'settings' => [],
            ],
            'settings' => [
                'cardinality' => 1,
            ],
        ],
    ],
];
